<?php

/*
 * OUGC Show As Sub Team plugin
 * Author: Omar Gonzalez.
 * Copyright:  2012 Omar Gonzalez, All Rights Reserved
 * 
 * Website: http://www.udezain.com.ar
 *
 * This plugin will allow you to show groups in the showteam.php page as a additional page.
 *
************************************************************/

/*
 * This plugin is under uDezain free plugins license. In short:
 * ============================================================
 * 1.- You may edit whatever you want to fit your needs without premission.
 * 2.- You MUST NOT redistribute this or any modified version of this plugin by any means without the author written permission.
 * 3.- You MUST NOT remove any license comments in any file that comes with this plugin pack.
 *
 * By downloading / installing / using this plugin you accept these conditions and the full attached license.
 * If no license file was attached within this plugin pack, you can read it in the following places:
 * 	1.- http://www.udezain.com.ar/eula-free.txt
 * 	2.- http://www.udezain.com.ar/eula-free.php
************************************************************/
 
// Die if IN_MYBB is not defined, for security reasons.
if(!defined('IN_MYBB'))
{
	die('This file cannot be accessed directly.');
}

//Cache our template.
if(my_strpos($_SERVER['PHP_SELF'], 'showteam.php'))
{
	global $templatelist;
	if(isset($templatelist))
	{
		$templatelist .= ', ougc_showassubteam';
	}
}

// Add the required hooks.
if(!defined('IN_ADMINCP'))
{
	$plugins->add_hook("showteam_start", "ougc_showassubteam_run");
	$plugins->add_hook("showteam_end", "ougc_showassubteam_showteam");
}

// Array of information about the plugin.
function ougc_showassubteam_info()
{
	global $lang;
	$lang->load('ougc_showassubteam');

	return array(
		"name"			=> $lang->ougc_sast_plugin_title,
		"description"	=> $lang->ougc_sast_plugin_title_desc,
		'website'		=> 'http://udezain.com.ar/',
		'author'		=> 'Omar G.',
		'authorsite'	=> 'http://udezain.com.ar/',
		"version"		=> "1.0",
		"guid" 			=> "927d037f020db55aed2a00d6e821d6da",
		"compatibility" => "16*"
	);
}

// This function runs when the plugin is activated.
function ougc_showassubteam_activate()
{
	global $db, $lang;
    $lang->load('ougc_showassubteam');
	$gid = $db->insert_query('settinggroups',array(
		'name'			=> 'ougc_showassubteam',
		'title'			=> $db->escape_string($lang->ougc_showassubteam_settints),
		'description'	=> $db->escape_string($lang->ougc_sast_plugin_title_desc),
		'disporder'		=> 999,
		'isdefault'		=> 'no'
	));
	$db->insert_query('settings',array(
		'name'			=> 'ougc_showassubteam_power',
		'title'			=> $db->escape_string($lang->ougc_showassubteam_power),
		'description'	=> $db->escape_string($lang->ougc_showassubteam_power_desc),
		'optionscode'	=> 'onoff',
		'value'			=> 0,
		'disporder'		=> 1,
		'gid'			=> intval($gid)
	));
	$db->insert_query('settings',array(
		'name'			=> 'ougc_showassubteam_guests',
		'title'			=> $db->escape_string($lang->ougc_showassubteam_guests),
		'description'	=> $db->escape_string($lang->ougc_showassubteam_guests_desc),
		'optionscode'	=> 'yesno',
		'value'			=> 1,
		'disporder'		=> 2,
		'gid'			=> intval($gid)
	));
	$db->insert_query('settings',array(
		'name'			=> 'ougc_showassubteam_groups',
		'title'			=> $db->escape_string($lang->ougc_showassubteam_groups),
		'description'	=> $db->escape_string($lang->ougc_showassubteam_groups_desc),
		'optionscode'	=> 'text',
		'value'			=> '',
		'disporder'		=> 3,
		'gid'			=> intval($gid)
	));
	$db->insert_query('settings',array(
		'name'			=> 'ougc_showassubteam_pagination',
		'title'			=> $db->escape_string($lang->ougc_showassubteam_pagination),
		'description'	=> $db->escape_string($lang->ougc_showassubteam_pagination_desc),
		'optionscode'	=> 'text',
		'value'			=> '20',
		'disporder'		=> 4,
		'gid'			=> intval($gid)
	));
	rebuild_settings();
	$db->insert_query("templates", array(
		"title"		=>	"ougc_showassubteam",
		"template"	=>	$db->escape_string('<a href="{$mybb->settings[\'bburl\']}/showteam.php?group={$usergroup[\'gid\']}" title="{$usergroup[\'usertitle\']}" rel="nofollow">{$usergroup[\'title\']}</a>'),
		"sid"		=>	"-1",
	));
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('showteam', '#'.preg_quote('{$grouplist}').'#', '{$grouplist}{$multipage}<div align="right">{$ougc_showassubteam}</div>');
}

//Deactivate the plugin.
function ougc_showassubteam_deactivate()
{
	global $db;
	$gid = $db->fetch_field($db->simple_select('settinggroups', 'gid', 'name="ougc_showassubteam"'), 'gid');
	if($gid)
	{
		$db->delete_query("settings", "gid='{$gid}'");
		$db->delete_query("settinggroups", "gid='{$gid}'");
		rebuild_settings();
	}
	$db->delete_query('templates', "title='ougc_showassubteam'");
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('showteam', '#'.preg_quote('<div align="right">{$ougc_showassubteam}</div>').'#', '', 0);
}

function ougc_showassubteam_run()
{
	global $mybb, $cache, $templates, $db, $lang, $headerinclude, $header, $footer, $theme;
	


	$gid = intval($mybb->input['group']);
	$multipage = '';
	if(($gid > 0) && $mybb->settings['ougc_showassubteam_power'] == 1 && !empty($mybb->settings['ougc_showassubteam_groups']) && ($mybb->user['uid'] || !$mybb->user['uid'] && $mybb->settings['ougc_showassubteam_guests'] == 1))
	{
		$groups = explode(',', $mybb->settings['ougc_showassubteam_groups']);
		$usergroups = $cache->read('usergroups');
		$usergroup = $usergroups[$gid];
		if($usergroup['gid'] && in_array($usergroup['gid'], $groups))
		{
			$q = $db->simple_select("users", "COUNT(uid) AS users", "displaygroup='{$usergroup['gid']}' OR usergroup='{$usergroup['gid']}' OR additionalgroups IN ({$usergroup['gid']})");
			$userscount = $db->fetch_field($q, "users");
			$db->free_result($q);
			if($userscount > 0)
			{
				$lang->forum_team .= ' ('.htmlspecialchars_uni($usergroup['title']).')';
				// Pagination stuff.
				$perpage = (intval($mybb->settings['ougc_showassubteam_pagination']) < 1 ? 99999*99999 : intval($mybb->settings['ougc_showassubteam_pagination']));
				if(intval($mybb->input['page']) > 0)
				{
					$page = $mybb->input['page'];
					$start = ($page-1)*$perpage;
					$pages = ceil($userscount/$perpage);
					if($page > $pages)
					{
						$start = 0;
						$page = 1;
					}
				}
				else
				{
						$page = 1;
						$start = 0;
				}
				$q = $db->simple_select("users", "uid, username, displaygroup, usergroup, ignorelist, hideemail, receivepms", "displaygroup='{$usergroup['gid']}' OR usergroup='{$usergroup['gid']}'", array('order_by' => 'username', 'limit' => $perpage, 'limit_start' => $start));
				$bgcolor = alt_trow();
				while($user = $db->fetch_array($q))
				{
					$user['username'] = format_name($user['username'], $user['usergroup'], $user['displaygroup']);
					$user['profilelink'] = get_profile_link($user['uid']);
					$emailcode = $pmcode = '';
					if($user['hideemail'] != 1)
					{
						eval("\$emailcode = \"".$templates->get("postbit_email")."\";");
					}
					if($user['receivepms'] != 0 && $mybb->settings['enablepms'] != 0 && my_strpos(",".$user['ignorelist'].",", ",".$mybb->user['uid'].",") === false)
					{
						eval("\$pmcode = \"".$templates->get("postbit_pm")."\";");
					}
					eval("\$usergrouprows .= \"".$templates->get("showteam_usergroup_user")."\";");
				}
				$db->free_result($q);
				eval("\$grouplist = \"".$templates->get("showteam_usergroup")."\";");
				$multipage = multipage($userscount, $perpage, $page, "showteam.php?group={$usergroup['gid']}");
				//add_breadcrumb($lang->forum_team);
				eval("\$page = \"".$templates->get("showteam")."\";");
				output_page($page);
				exit;
			}
		}
	}
}

function ougc_showassubteam_showteam()
{
	global $mybb, $ougc_showassubteam, $cache, $templates;
	$ougc_showassubteam = '';
	if($mybb->settings['ougc_showassubteam_power'] == 1 && !empty($mybb->settings['ougc_showassubteam_groups']) && ($mybb->user['uid'] || !$mybb->user['uid'] && $mybb->settings['ougc_showassubteam_guests'] == 1))
	{
		$groups = explode(',', $mybb->settings['ougc_showassubteam_groups']);
		$usergroups = $cache->read('usergroups');
		$ougc_showassubteam = '';
		foreach($groups as $group)
		{
			$usergroup = $usergroups[intval($group)];
			if($usergroup['gid'])
			{
				$usergroup['gid'] = intval($usergroup['gid']);
				$usergroup['title'] = str_replace('{username}', htmlspecialchars_uni($usergroup['title']), $usergroup['namestyle']);
				$usergroup['usertitle'] = htmlspecialchars_uni($usergroup['usertitle']);
				eval("\$ougc_showassubteam .= \"".$templates->get("ougc_showassubteam")."\";");
			}
		}
	}
}
?>